##########################  Calculate the European option price based on the approximation of the transition density ##########
###### x, beta, Ts: output of RND.r
###### K: strike
###### r: interest
###### delta: continuous payout
###### tau: maturity
###### B1: stock price
###### sigma: variance

EO_app<-function(x,beta,Ts,sigma,r,delta,ta,K,B1,type){
  
  if (B1<1e-5)
  {B1<-1e-5}
  
  tau<-t-ta
  if (type=="P") {
    ST  <- exp(x*sigma*sqrt(tau) + (r)*tau + log(B1))
    pos<-which(ST<=K)
    STK<-ST[pos]
    RND_ST <- t(Ts) %*% beta / (sigma*sqrt(tau)*ST)
    RND_STK<-RND_ST[pos]
    if (length(STK)>=2){
      dST<-STK[2:length(STK)]-STK[1:(length(STK)-1)]
      EO_app1<-(exp(-r*tau)*((K-STK[1:(length(STK)-1)])*RND_STK[1:(length(RND_STK)-1)]) %*% dST)[1]
      EO_app2<-(exp(-r*tau)*((K-STK[2:(length(STK))])*RND_STK[2:(length(RND_STK))]) %*% dST)[1]
      EO_app<-(EO_app1+EO_app2)/2
    }else if (length(STK)==1){
      EO_app<-(exp(-r*tau)*((K-STK)*RND_STK) %*% (K-STK))
    }
    else
      {EO_app<-0}
  } else if (type=="C") {
    ST  <- exp(x*sigma*sqrt(tau) + (r)*tau + log(B1))
    pos<-which(ST>=K)
    STK<-ST[pos]
    RND_ST <- t(Ts) %*% beta / (sigma*sqrt(tau)*ST)
    RND_STK<-RND_ST[pos]
    if (length(STK)>=2){
      dST<-STK[2:length(STK)]-STK[1:(length(STK)-1)]
      EO_app1<-(exp(-r*tau)*((STK[1:(length(STK)-1)]-K)*RND_STK[1:(length(RND_STK)-1)]) %*% dST)[1]
      EO_app2<-(exp(-r*tau)*((STK[2:(length(STK))]-K)*RND_STK[2:(length(RND_STK))]) %*% dST)[1]
      EO_app<-(EO_app1+EO_app2)/2
    }else if (length(STK)==1){
      EO_app<-(exp(-r*tau)*((STK-K)*RND_STK) %*% (STK-K))
    }
    else
    {EO_app<-0}
  }
  return(EO_app)
}

